/*
 * Decompiled with CFR 0.152.
 */
package net.dclausen.microfloat;

import net.dclausen.microfloat.BitUtils;
import net.dclausen.microfloat.MicroDouble;

public final class MicroFloat {
    public static final int POSITIVE_INFINITY = 2139095040;
    public static final int NEGATIVE_INFINITY = -8388608;
    public static final int NaN = 2143289344;
    public static final int MAX_VALUE = 0x7F7FFFFF;
    public static final int MIN_VALUE = 1;
    public static final int E = 1076754516;
    public static final int PI = 1078530011;
    public static final int ZERO = 0;
    public static final int NEGATIVE_ZERO = Integer.MIN_VALUE;
    public static final int ONE = 1065353216;
    public static final int TWO = 0x40000000;
    public static final int ONE_HALF = 0x3F000000;
    private static final int ABS_MASK = Integer.MAX_VALUE;
    private static final int SIGN_MASK = Integer.MIN_VALUE;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int FRACTION_MASK = 0x7FFFFF;
    private static final int IMPLIED_ONE = 0x800000;
    private static final int[] pow10m = new int[]{-1003958181, -1723866425, -277622185, -1156416428, -1842974431, -463728444, -1301811943, -1956564676, -641213203, -1440471911, -2064892776, -810475859, -1572708361, -41437709, -971897307, -1698818867, -238485375, -1125840795, -1819087217, -426404673, -1272652747, -1933784055, -605618481, -1412663534, -2043167482, -776530087, -1546188227, Integer.MIN_VALUE, -939524096, -1673527296, -198967296, -1094967296, -1794967296, -388717296, -1243209483, -1910781505, -569676998, -1384584250, -2021230542, -742253617, -1519409734, -2126562951, -906835507, -1647989336, -159064233, -1063793028, -1770612399};
    private static final short[] pow10x = new short[]{-211, -204, -198, -191, -184, -178, -171, -164, -158, -151, -144, -138, -131, -125, -118, -111, -105, -98, -91, -85, -78, -71, -65, -58, -51, -45, -38, -31, -25, -18, -12, -5, 2, 8, 15, 22, 28, 35, 42, 48, 55, 62, 68, 75, 81, 88, 95};
    private static final int[] pow2m = new int[]{-1285701758, 770371978, 1972152263, 504870979, 1292469707, -986244846, 847032947, -2126562951, 555111512, 1421085472, -656988489, 931322575, -1910781505, 610351563, 1562500000, -294967296, 1024000000, -1673527296, 0x28000000, 0x66666666, 439804651, 1125899907, -1412663534, 737869763, 1888946593, 483570328, 1237940039, -1125840795, 811296384, 2076918743, 531691198, 1361129468};
    private static final byte[] pow2x = new byte[]{-45, -42, -40, -37, -35, -33, -30, -28, -25, -23, -21, -18, -16, -13, -11, -9, -6, -4, -1, 1, 4, 6, 8, 11, 13, 16, 18, 20, 23, 25, 28, 30};
    private final int value;

    static boolean unpackSign(int f) {
        return f < 0;
    }

    static int unpackExponent(int f) {
        return (f >> 23 & 0xFF) - 150;
    }

    static int unpackMantissa(int f) {
        if ((f & 0x7F800000) == 0) {
            return (f & 0x7FFFFF) << 1;
        }
        return f & 0x7FFFFF | 0x800000;
    }

    static int pack(boolean negative, int exponent, int mantissa) {
        int shift = BitUtils.countLeadingZeros(mantissa);
        return MicroFloat.pack2(negative, exponent -= shift, mantissa <<= shift);
    }

    static int pack(boolean negative, int exponent, long mantissa) {
        int shift = 32 - BitUtils.countLeadingZeros(mantissa);
        exponent += shift;
        if (shift > 0) {
            mantissa = BitUtils.stickyRightShift(mantissa, shift);
        } else if (shift < 0) {
            mantissa <<= -shift;
        }
        return MicroFloat.pack2(negative, exponent, (int)mantissa);
    }

    private static int pack2(boolean negative, int exponent, int mantissa) {
        if (mantissa != 0) {
            if (exponent < -157) {
                mantissa = BitUtils.roundingRightShift(mantissa, -149 - exponent);
            } else {
                if ((mantissa = BitUtils.roundingRightShift(mantissa, 8)) == 0x1000000) {
                    mantissa = 0x800000;
                    ++exponent;
                }
                if (exponent > 96) {
                    mantissa = 2139095040;
                } else {
                    mantissa ^= 0x800000;
                    mantissa |= exponent + 158 << 23;
                }
            }
        }
        if (negative) {
            mantissa |= Integer.MIN_VALUE;
        }
        return mantissa;
    }

    public static boolean isNaN(int f) {
        return (f & Integer.MAX_VALUE) > 2139095040;
    }

    public static boolean isInfinite(int f) {
        return (f & Integer.MAX_VALUE) == 2139095040;
    }

    public static boolean isZero(int f) {
        return (f & Integer.MAX_VALUE) == 0;
    }

    public static int abs(int f) {
        return f & Integer.MAX_VALUE;
    }

    public static int negate(int f) {
        if (MicroFloat.isNaN(f)) {
            return 2143289344;
        }
        return f ^ Integer.MIN_VALUE;
    }

    public static boolean eq(int f1, int f2) {
        return f1 == f2 && !MicroFloat.isNaN(f1) || MicroFloat.isZero(f1) && MicroFloat.isZero(f2);
    }

    public static boolean ne(int f1, int f2) {
        return !MicroFloat.eq(f1, f2);
    }

    public static boolean lt(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return false;
        }
        if (f2 == 0) {
            f2 = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(f1, f2) < 0;
    }

    public static boolean le(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return false;
        }
        if (f2 == Integer.MIN_VALUE) {
            f2 = 0;
        }
        return MicroFloat.cmp(f1, f2) <= 0;
    }

    public static boolean gt(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return false;
        }
        if (f1 == 0) {
            f1 = Integer.MIN_VALUE;
        }
        return MicroFloat.cmp(f1, f2) > 0;
    }

    public static boolean ge(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return false;
        }
        if (f1 == Integer.MIN_VALUE) {
            f1 = 0;
        }
        return MicroFloat.cmp(f1, f2) >= 0;
    }

    public static int compare(int f1, int f2) {
        boolean n1 = MicroFloat.isNaN(f1);
        boolean n2 = MicroFloat.isNaN(f2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 0;
            }
            return n1 ? 1 : -1;
        }
        return MicroFloat.cmp(f1, f2);
    }

    public static int max(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return 2143289344;
        }
        return MicroFloat.cmp(f1, f2) < 0 ? f2 : f1;
    }

    public static int min(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return 2143289344;
        }
        return MicroFloat.cmp(f1, f2) > 0 ? f2 : f1;
    }

    private static int cmp(int f1, int f2) {
        if (f1 < 0) {
            if (f2 < 0) {
                return f2 - f1;
            }
            return -1;
        }
        if (f2 < 0) {
            return 1;
        }
        return f1 - f2;
    }

    public static int intToFloat(int x) {
        if (x < 0) {
            return MicroFloat.pack(true, 0, -x);
        }
        return MicroFloat.pack(false, 0, x);
    }

    public static int longToFloat(long x) {
        if (x < 0L) {
            return MicroFloat.pack(true, 0, -x);
        }
        return MicroFloat.pack(false, 0, x);
    }

    public static int doubleToFloat(long d) {
        if (MicroDouble.isNaN(d)) {
            return 2143289344;
        }
        boolean n = MicroDouble.unpackSign(d);
        if (MicroDouble.isZero(d)) {
            return n ? Integer.MIN_VALUE : 0;
        }
        if (MicroDouble.isInfinite(d)) {
            return n ? -8388608 : 2139095040;
        }
        int x = MicroDouble.unpackExponent(d);
        long m = MicroDouble.unpackMantissa(d);
        return MicroFloat.pack(n, x, m);
    }

    public static byte byteValue(int f) {
        long x = MicroFloat.intValue(f);
        return (byte)x;
    }

    public static short shortValue(int f) {
        long x = MicroFloat.intValue(f);
        return (short)x;
    }

    public static int intValue(int f) {
        long x = MicroFloat.longValue(f);
        if (x >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static long longValue(int f) {
        if (MicroFloat.isNaN(f)) {
            return 0L;
        }
        boolean n = MicroFloat.unpackSign(f);
        int x = MicroFloat.unpackExponent(f);
        long m = MicroFloat.unpackMantissa(f);
        if (x > 0) {
            if (x >= 63 || m >> 63 - x != 0L) {
                return n ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            m <<= x;
        } else {
            if (x <= -24) {
                return 0L;
            }
            m >>>= -x;
        }
        return n ? -m : m;
    }

    public static long doubleValue(int f) {
        return MicroDouble.floatToDouble(f);
    }

    public static int add(int f1, int f2) {
        int f;
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return 2143289344;
        }
        boolean n1 = MicroFloat.unpackSign(f1);
        boolean n2 = MicroFloat.unpackSign(f2);
        boolean i1 = MicroFloat.isInfinite(f1);
        boolean i2 = MicroFloat.isInfinite(f2);
        if (i1 || i2) {
            if (i1 && i2) {
                if (n1 != n2) {
                    return 2143289344;
                }
                return f1;
            }
            if (i1) {
                return f1;
            }
            return f2;
        }
        boolean z1 = MicroFloat.isZero(f1);
        boolean z2 = MicroFloat.isZero(f2);
        if (z1 || z2) {
            if (z1 && z2) {
                if (n1 != n2) {
                    return 0;
                }
                return f1;
            }
            if (z1) {
                return f2;
            }
            return f1;
        }
        int m1 = MicroFloat.unpackMantissa(f1) << 3;
        int x1 = MicroFloat.unpackExponent(f1) - 3;
        int m2 = MicroFloat.unpackMantissa(f2) << 3;
        int x2 = MicroFloat.unpackExponent(f2) - 3;
        int dx = x1 - x2;
        if (dx > 0) {
            m2 = BitUtils.stickyRightShift(m2, dx);
            x2 = x1;
        } else if (dx < 0) {
            m1 = BitUtils.stickyRightShift(m1, -dx);
            x1 = x2;
        }
        if (n1 ^ n2) {
            if (m1 > m2) {
                m2 = -m2;
            } else {
                m1 = -m1;
                n1 = n2;
            }
        }
        if ((f = MicroFloat.pack(n1, x1, m1 += m2)) == Integer.MIN_VALUE) {
            return 0;
        }
        return f;
    }

    public static int sub(int f1, int f2) {
        return MicroFloat.add(f1, MicroFloat.negate(f2));
    }

    public static int mul(int f1, int f2) {
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return 2143289344;
        }
        boolean negative = MicroFloat.unpackSign(f1) ^ MicroFloat.unpackSign(f2);
        if (MicroFloat.isInfinite(f1) || MicroFloat.isInfinite(f2)) {
            if (MicroFloat.isZero(f1) || MicroFloat.isZero(f2)) {
                return 2143289344;
            }
            return negative ? -8388608 : 2139095040;
        }
        int m1 = MicroFloat.unpackMantissa(f1);
        int x1 = MicroFloat.unpackExponent(f1);
        int m2 = MicroFloat.unpackMantissa(f2);
        int x2 = MicroFloat.unpackExponent(f2);
        long m = (long)m1 * (long)m2;
        return MicroFloat.pack(negative, x1 += x2, m);
    }

    public static int div(int f1, int f2) {
        boolean r;
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2)) {
            return 2143289344;
        }
        boolean negative = MicroFloat.unpackSign(f1) ^ MicroFloat.unpackSign(f2);
        boolean n1 = MicroFloat.isInfinite(f1);
        boolean n2 = MicroFloat.isInfinite(f2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 2143289344;
            }
            if (n1) {
                return negative ? -8388608 : 2139095040;
            }
            return negative ? Integer.MIN_VALUE : 0;
        }
        n1 = MicroFloat.isZero(f1);
        n2 = MicroFloat.isZero(f2);
        if (n1 || n2) {
            if (n1 && n2) {
                return 2143289344;
            }
            if (n1) {
                return negative ? Integer.MIN_VALUE : 0;
            }
            return negative ? -8388608 : 2139095040;
        }
        int m1 = MicroFloat.unpackMantissa(f1);
        int x1 = MicroFloat.unpackExponent(f1);
        int m2 = MicroFloat.unpackMantissa(f2);
        int x2 = MicroFloat.unpackExponent(f2);
        int s = BitUtils.countLeadingZeros(m1) + 22;
        long m3 = (long)m1 << s;
        int x = x1 - x2 - s;
        long m = m3 / (long)m2;
        boolean bl = r = m * (long)m2 != m3;
        if (r) {
            m |= 1L;
        }
        return MicroFloat.pack(negative, x, m);
    }

    public static int mod(int f1, int f2) {
        int x2;
        if (MicroFloat.isNaN(f1) || MicroFloat.isNaN(f2) || MicroFloat.isInfinite(f1) || MicroFloat.isZero(f2)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(f1) || MicroFloat.isInfinite(f2)) {
            return f1;
        }
        int x1 = MicroFloat.unpackExponent(f1);
        if (x1 < (x2 = MicroFloat.unpackExponent(f2))) {
            return f1;
        }
        boolean n = MicroFloat.unpackSign(f1);
        int m1 = MicroFloat.unpackMantissa(f1);
        int m2 = MicroFloat.unpackMantissa(f2);
        if (x1 == x2) {
            m1 %= m2;
        } else {
            while (x1 != x2) {
                int s = Math.min(39, x1 - x2);
                x1 -= s;
                m1 = (int)(((long)m1 << s) % (long)m2);
            }
        }
        return MicroFloat.pack(n, x1, m1);
    }

    public static int truncate(int f) {
        return MicroFloat.round(f, false, MicroFloat.unpackSign(f));
    }

    public static int rint(int f) {
        return MicroFloat.round(f, true, false);
    }

    public static int floor(int f) {
        return MicroFloat.round(f, false, false);
    }

    public static int ceil(int f) {
        return MicroFloat.round(f, false, true);
    }

    public static int round(int f) {
        return MicroFloat.intValue(MicroFloat.floor(MicroFloat.add(f, 0x3F000000)));
    }

    private static int round(int f, boolean round, boolean ceil) {
        if (MicroFloat.isNaN(f)) {
            return 2143289344;
        }
        if (MicroFloat.isZero(f) || MicroFloat.isInfinite(f)) {
            return f;
        }
        int x = MicroFloat.unpackExponent(f);
        if (x >= 0) {
            return f;
        }
        boolean n = MicroFloat.unpackSign(f);
        int m = MicroFloat.unpackMantissa(f);
        if (round) {
            m = BitUtils.roundingRightShift(m, -x);
        } else {
            int r;
            if (x <= -32) {
                r = m;
                m = 0;
            } else {
                r = m << 32 + x;
                m >>>= -x;
            }
            if (n ^ ceil && r != 0) {
                ++m;
            }
        }
        return MicroFloat.pack(n, 0, m);
    }

    private static int decToFloat(boolean negative, int base10x, int base10m) {
        boolean mod;
        if (base10m == 0) {
            return negative ? Integer.MIN_VALUE : 0;
        }
        while (base10m > 0 && base10m <= 0x19999999) {
            base10m = (base10m << 3) + (base10m << 1);
            --base10x;
        }
        boolean bl = mod = ((base10x += 54) & 1) != 0;
        if ((base10x >>= 1) < 0) {
            return negative ? Integer.MIN_VALUE : 0;
        }
        if (base10x > 46) {
            return negative ? -8388608 : 2139095040;
        }
        int base2x = pow10x[base10x];
        long base2m = ((long)base10m & 0xFFFFFFFFL) * ((long)pow10m[base10x] & 0xFFFFFFFFL);
        if (mod) {
            if (base2m < 0L) {
                base2m >>>= 1;
                ++base2x;
            }
            base2m += base2m >>> 2;
            base2x += 3;
        }
        return MicroFloat.pack(negative, base2x, base2m);
    }

    public static int parseFloat(String s) {
        int len = (s = s.trim().toUpperCase()).length();
        if (len == 0) {
            throw new NumberFormatException(s);
        }
        if ("NAN".equals(s)) {
            return 2143289344;
        }
        int idx = 0;
        boolean negative = false;
        char c = s.charAt(0);
        boolean bl = negative = c == '-';
        if (negative || c == '+') {
            idx = 1;
        }
        if (idx < len && ((c = s.charAt(idx)) == 'I' || c == 'i') && "INFINITY".equals(s.substring(idx))) {
            return negative ? -8388608 : 2139095040;
        }
        int mantissa = 0;
        int exponent = 0;
        int fractionChars = 0;
        boolean sticky = false;
        boolean readingFraction = false;
        while (idx < len) {
            c = s.charAt(idx);
            if (c == '.') {
                if (readingFraction) {
                    throw new NumberFormatException(s);
                }
                readingFraction = true;
            } else {
                if (c < '0' || c > '9') break;
                ++fractionChars;
                if (mantissa <= 0x19999998) {
                    mantissa = (mantissa << 3) + (mantissa << 1) + (c - 48);
                    if (readingFraction) {
                        --exponent;
                    }
                } else {
                    if (!readingFraction) {
                        ++exponent;
                    }
                    sticky |= c != '0';
                }
            }
            ++idx;
        }
        if (fractionChars == 0) {
            throw new NumberFormatException(s);
        }
        if (idx + 1 < len && (s.charAt(idx) == 'E' || s.charAt(idx) == 'e')) {
            try {
                exponent += Integer.parseInt(s.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(s);
            }
            idx = len;
        } else if (idx != len) {
            throw new NumberFormatException(s);
        }
        return MicroFloat.decToFloat(negative, exponent, mantissa);
    }

    public static String toString(int f) {
        int i;
        int dp;
        boolean scientific;
        if (MicroFloat.isNaN(f)) {
            return "NaN";
        }
        boolean n = MicroFloat.unpackSign(f);
        StringBuffer sb = new StringBuffer(15);
        if (n) {
            sb.append('-');
        }
        if (MicroFloat.isZero(f)) {
            sb.append("0.0");
            return sb.toString();
        }
        if (MicroFloat.isInfinite(f)) {
            sb.append("Infinity");
            return sb.toString();
        }
        int base2x = MicroFloat.unpackExponent(f);
        int base2m = MicroFloat.unpackMantissa(f);
        int idx = base2x + 150;
        int dx = idx & 7;
        base2m <<= dx;
        int base10x = pow2x[idx >>= 3];
        while (base2m <= 0xCCCCCCC) {
            base2m = (base2m << 3) + (base2m << 1);
            --base10x;
        }
        long base10ml = (long)base2m * ((long)pow2m[idx] & 0xFFFFFFFFL);
        int base10m = (int)(base10ml >>> 32);
        if (base10ml << 32 < 0L) {
            ++base10m;
        }
        boolean roundedUp = false;
        while (true) {
            int r = base10m % 10;
            int mt = base10m / 10;
            int xt = base10x + 1;
            if (r != 0) {
                if (r > 5 || r == 5 && !roundedUp) {
                    roundedUp = true;
                    ++mt;
                } else {
                    roundedUp = false;
                }
                int ft = MicroFloat.decToFloat(n, xt, mt);
                if (ft != f) {
                    mt = roundedUp ? --mt : ++mt;
                    roundedUp ^= true;
                    ft = MicroFloat.decToFloat(n, xt, mt);
                    if (ft != f) break;
                }
            }
            base10m = mt;
            base10x = xt;
        }
        String s = Integer.toString(base10m);
        boolean bl = scientific = (base10x += s.length() - 1) < -3 || base10x >= 7;
        if (scientific) {
            dp = 1;
        } else {
            dp = base10x + 1;
            if (dp < 1) {
                sb.append('0');
            }
        }
        for (i = 0; i < dp; ++i) {
            if (i < s.length()) {
                sb.append(s.charAt(i));
                continue;
            }
            sb.append('0');
        }
        sb.append('.');
        if (dp >= s.length()) {
            sb.append('0');
        } else {
            for (i = dp; i < s.length(); ++i) {
                if (i < 0) {
                    sb.append('0');
                    continue;
                }
                sb.append(s.charAt(i));
            }
        }
        if (scientific) {
            sb.append('E');
            sb.append(Integer.toString(base10x));
        }
        return sb.toString();
    }

    public MicroFloat(int f) {
        if (MicroFloat.isNaN(f)) {
            f = 2143289344;
        }
        this.value = f;
    }

    public MicroFloat(String s) {
        this(MicroFloat.parseFloat(s));
    }

    public int floatValue() {
        return this.value;
    }

    public String toString() {
        return MicroFloat.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof MicroFloat && ((MicroFloat)obj).value == this.value;
    }
}

